package jamezo97.clonecraft.block;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.GuiHandler;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockLifeInducer extends BlockContainer{


	public BlockLifeInducer(int par1) {
		super(par1, Material.rock);
		setTextureName("CloneCraft:transmogrifier_top");
	}
	
	
	@Override
	public Icon getIcon(int side, int meta) {
		if(side == 1){
			return this.blockIcon;
		}else{
			return CloneCraft.sterilizer.getDefaultSideIcon();
		}
	}

	public Icon getTopIconThing(){
		return blockIcon;
	}





	@Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
		TileEntity te = par1World.getBlockTileEntity(par2, par3, par4);
		if(te != null && te instanceof IInventory){
			IInventory inven = (IInventory)te;
			for(int a = 0; a < inven.getSizeInventory(); a++){
				ItemStack stack = inven.getStackInSlot(a);
				if(stack != null){
					EntityItem item = new EntityItem(par1World, par2+.5, par3+.5, par4+.5, stack);
					item.delayBeforeCanPickup = 10;
					par1World.spawnEntityInWorld(item);
				}
			}
			if(te instanceof TileEntityLifeInducer){
				((TileEntityLifeInducer)te).onBroken();
			}
		}
		
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}


	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
		par5EntityPlayer.openGui(CloneCraft.instance, GuiHandler.LIFEINDUCER, par1World, par2, par3, par4);
		return true;
	}




	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntityLifeInducer();
	}
	
	
}
